/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class ConglomerateUtil {
    public static Properties createRawStorePropertySet(Properties properties) {
        properties = ConglomerateUtil.createUserRawStorePropertySet(properties);
        ((Hashtable)properties).put("derby.storage.reusableRecordId", "");
        return properties;
    }

    public static Properties createUserRawStorePropertySet(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        ((Hashtable)properties).put("derby.storage.pageSize", "");
        ((Hashtable)properties).put("derby.storage.minimumRecordSize", "");
        ((Hashtable)properties).put("derby.storage.pageReservedSpace", "");
        ((Hashtable)properties).put("derby.storage.initialPages", "");
        return properties;
    }

    public static int[] createFormatIds(DataValueDescriptor[] dataValueDescriptorArray) {
        int[] nArray = new int[dataValueDescriptorArray.length];
        int n = 0;
        while (n < dataValueDescriptorArray.length) {
            nArray[n] = dataValueDescriptorArray[n].getTypeFormatId();
            ++n;
        }
        return nArray;
    }

    public static int[] readFormatIdArray(int n, ObjectInput objectInput) throws IOException {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = FormatIdUtil.readFormatIdInteger(objectInput);
            ++n2;
        }
        return nArray;
    }

    public static void writeFormatIdArray(int[] nArray, ObjectOutput objectOutput) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            FormatIdUtil.writeFormatIdInteger(objectOutput, nArray[n]);
            ++n;
        }
    }

    public static String debugPage(Page page, int n, boolean bl, DataValueDescriptor[] dataValueDescriptorArray) {
        return null;
    }
}

